/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.defense;

import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.data.ModifierMaxLevel;
import slimeknights.tconstruct.library.modifiers.impl.IncrementalModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentChangeContext;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.utils.Util;
import slimeknights.tconstruct.tools.TinkerModifiers;

public abstract class AbstractProtectionModifier<T extends ModifierMaxLevel>
extends IncrementalModifier {
    private final TinkerDataCapability.TinkerDataKey<T> key;

    @Deprecated
    protected abstract T createData();

    protected T createData(EquipmentChangeContext context) {
        return this.createData();
    }

    @Deprecated
    protected void reset(T data) {
    }

    protected void reset(T data, EquipmentChangeContext context) {
        this.reset(data);
    }

    protected void set(T data, class_1304 slot, float scaledLevel, EquipmentChangeContext context) {
        ((ModifierMaxLevel)data).set(slot, scaledLevel);
    }

    @Override
    public void onUnequip(IToolStackView tool, int level, EquipmentChangeContext context) {
        class_1309 entity = context.getEntity();
        class_1304 slot = context.getChangedSlot();
        if (ModifierUtil.validArmorSlot(tool, slot) && !entity.method_37908().field_9236) {
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData != null) {
                    this.set(modData, slot, 0.0f, context);
                    if (modData.getMax() == 0.0f) {
                        this.reset(modData, context);
                    }
                }
            });
        }
    }

    @Override
    public void onEquip(IToolStackView tool, int level, EquipmentChangeContext context) {
        class_1309 entity = context.getEntity();
        class_1304 slot = context.getChangedSlot();
        if (!entity.method_37908().field_9236 && ModifierUtil.validArmorSlot(tool, slot) && !tool.isBroken()) {
            float scaledLevel = this.getScaledLevel(tool, level);
            context.getTinkerData().ifPresent(data -> {
                ModifierMaxLevel modData = (ModifierMaxLevel)data.get(this.key);
                if (modData == null) {
                    modData = this.createData(context);
                    data.put(this.key, modData);
                }
                this.set(modData, slot, scaledLevel, context);
            });
        }
    }

    public static void addResistanceTooltip(Modifier modifier, IToolStackView tool, int level, float multiplier, List<class_2561> tooltip) {
        if (tool.hasTag(TinkerTags.Items.ARMOR)) {
            float cap = Math.min(0.95f, 0.8f + (float)tool.getModifierLevel(TinkerModifiers.boundless.getId()) * 0.1f);
            tooltip.add((class_2561)modifier.applyStyle(class_2561.method_43470((String)Util.PERCENT_BOOST_FORMAT.format(Math.min(modifier.getEffectiveLevel(tool, level) * multiplier / 25.0f, cap))).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)(modifier.getTranslationKey() + ".resistance")))));
        }
    }

    public AbstractProtectionModifier(TinkerDataCapability.TinkerDataKey<T> key) {
        this.key = key;
    }
}

